USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_LibraryEligibility]    Script Date: 9/25/2014 14:58:19 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-09-11, finished then started weeks ago>
-- Description:	<This will calculate the lilbrary popularity scores of libraries, and determine the libraries>
-- =============================================
ALTER PROCEDURE [dbo].[RP_LibraryEligibility] 
	@errorMessage varchar(2048) OUTPUT
AS
DECLARE @dailyBudgetDate date, @popularityThreshold int
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	-- SET XACT_ABORT ON will cause the transaction to be uncommittable when the constraint violation occurs. 
	SET XACT_ABORT ON;
	SELECT @errorMessage = 'completed sucessfully';
	BEGIN TRY
	BEGIN TRANSACTION LibraryEligibility WITH MARK;

	-- The DEFAULTFILE THING
	DELETE rpd FROM [dbo].[RewardProjectDependency] rpd 
	WHERE NOT EXISTS (SELECT DefaultFileID FROM [dbo].[RewardLegacyProject] rlp WHERE rlp.DefaultFileID = rpd.DefaultFileID)

	-- REMOVE BLACK LISTED PROJECTS!!!!!
	DELETE  rpd
	FROM [dbo].[RewardProjectDependency] AS rpd
	JOIN [dbo].[RewardLegacyProject] rlp ON rpd.DefaultFileID = rlp.DefaultFileID
	JOIN [dbo].[RewardProject] AS rp ON rlp.ID = rp.id
	where IsBlacklisted = 1


	DELETE  rpd
	FROM [dbo].[RewardProjectDependency] AS rpd
	JOIN [dbo].[RewardProject] AS rp ON rpd.DependencyProjectID  = rp.id
	where IsBlacklisted = 1

-- get the needed values
SELECT @dailyBudgetDate = GETUTCDATE();

-- check if daily budget exist for today if not run it.. need it for @popularityThreshold
IF (SELECT ID FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate) IS NULL
		BEGIN
			EXEC [dbo].RP_GenerateDailyBudget;
		END;

SELECT @popularityThreshold = (SELECT PopularityThreshold FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate);

-- set up needed temp table
IF OBJECT_ID('tempdb..#tempAddonUseThisManyLibraries') IS NOT NULL
    DROP TABLE #tempAddonUseThisManyLibraries
CREATE TABLE #tempAddonUseThisManyLibraries(NumberLibsUsed int, DefaultFileID int, SharedPopScore decimal(19,9));  
INSERT INTO #tempAddonUseThisManyLibraries(NumberLibsUsed, DefaultFileID, SharedPopScore)
SELECT COUNT(rpd.DefaultFileID) AS NumberLibsUsed, rpd.DefaultFileID,  rpp.PopularityScore/COUNT(rpd.DefaultFileID) AS SharedPopScore  
FROM [dbo].[RewardProjectDependency] rpd
LEFT JOIN [dbo].[RewardLegacyProject] rlp ON rpd.DefaultFileID = rlp.DefaultFileID
LEFT JOIN [dbo].[RewardProject] rpp ON rlp.ID = rpp.ID
GROUP BY rpd.DefaultFileID, rpp.PopularityScore
ORDER BY rpd.DefaultFileID



-- now that libraries of libraries have been used in the count for are you a library now take them out so we do not add their points, two deletes for this in the temp table and RPD
  DELETE rpd FROM #tempAddonUseThisManyLibraries rpd
  WHERE rpd.DefaultFileID  in (SELECT DISTINCT rlp.DefaultFileID 
									FROM [dbo].[RewardProjectDependency] rpdt
									JOIN [dbo].[RewardLegacyProject] rlp ON rpdt.DependencyProjectID = rlp.ID 
									WHERE rlp.DefaultFileID = rpd.DefaultFileID)

  -- now take out ones that do not pass the required number of times it is used as a library
	delete from [dbo].[RewardProjectDependency] where DependencyProjectID in (
	select DependencyProjectID FROM [dbo].[RewardProjectDependency] 
	GROUP BY DependencyProjectID
	having count(DependencyProjectID) < (SELECT LibraryThreshold FROM [dbo].[RewardsProgram]))


	-- now that libraries of libraries have been used in the count for are you a library now take them out so we do not add their points, two deletes for this in the temp table and RPD
	Delete rpds FROM [dbo].[RewardProjectDependency] rpds
	WHERE rpds.DefaultFileID in (SELECT DISTINCT rlp.DefaultFileID 
	FROM [dbo].[RewardProjectDependency] rpdt
	JOIN [dbo].[RewardLegacyProject] rlp ON rpdt.DependencyProjectID = rlp.ID 
	WHERE rlp.DefaultFileID = rpds.DefaultFileID)

	-- get library scores of the eligible libraries
;WITH LibScores (DependencyProjectID, LibraryPopularityScore) AS
(
	SELECT rpd.DependencyProjectID, SUM(sps.SharedPopScore) AS LibraryPopularityScore
		FROM [dbo].[RewardProjectDependency] rpd
			LEFT JOIN #tempAddonUseThisManyLibraries sps ON rpd.DefaultFileID = sps.DefaultFileID
			LEFT JOIN [dbo].[RewardProject] rpp ON rpd.DependencyProjectID = rpp.ID
		GROUP BY rpd.DependencyProjectID, rpp.PopularityScore
		HAVING COUNT(rpd.DependencyProjectID) >= (SELECT LibraryThreshold FROM [dbo].[RewardsProgram]) and
		 SUM(sps.SharedPopScore) + rpp.PopularityScore >= @popularityThreshold
)
MERGE [dbo].[RewardSplit] AS TARGET
USING LibScores AS SOURCE
ON (TARGET.ProjectID = SOURCE.DependencyProjectID)
WHEN MATCHED THEN
	UPDATE SET TARGET.LibraryPopularity = SOURCE.LibraryPopularityScore, TARGET.IsLibrary = 1;

DROP TABLE #tempAddonUseThisManyLibraries;

COMMIT TRANSACTION LibraryEligibility;
END TRY
BEGIN CATCH
	ROLLBACK TRANSACTION LibraryEligibility;
	SELECT @errorMessage = ERROR_MESSAGE();
	RETURN(930);
END CATCH;
	RETURN(1);
END

GO


